<?php
function sm_register_shortcode_handler_sm_team_member() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_team_member extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_team_member_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_team_member', 'sm_team_member_func' );
	}
}

function sm_team_member_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);

	return sm_render_view( 'team-member', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Team Member', 'semona-extension' ),
	'base' => 'sm_team_member',
	'category' =>  esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Individual Team Member with Avatar', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-team_member.png',
	'params' => array_merge(
		array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Style', 'semona-extension' ),
				'param_name' => 'style',
				'value' => sm_get_team_member_styles_array(),
			),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__( 'Photo', 'semona-extension' ),
				'param_name' => 'photo',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Name', 'semona-extension' ),
				'param_name' => 'name',
				"value" => '',
				"admin_label" => true,
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Title', 'semona-extension' ),
				'param_name' => 'title',
				"value" => '',
				"admin_label" => true,
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Name Color', 'semona-extension' ),
				'param_name' => 'name_color',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Title Color', 'semona-extension' ),
				'param_name' => 'title_color',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'textarea',
				'heading' => esc_html__( 'Description', 'semona-extension' ),
				'param_name' => 'content',
				'dependency' => array(
					'element' => 'style',
					'value' => array( 'sm-style3', 'sm-style4', 'sm-style6' )
				)
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Description Color', 'semona-extension' ),
				'param_name' => 'content_color',
				'dependency' => array(
					'element' => 'style',
					'value' => array( 'sm-style3', 'sm-style4' )
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Link', 'semona-extension' ),
				'param_name' => 'link',
				'value' => '',
			),
			sm_css_animation_class(),
			sm_css_animation_delay(),
			sm_extra_class(),
		),
		sm_get_social_links_options_array()
	)
) );